from __future__ import annotations

import typer

from .config import get_settings
from .browser import start_session, stop_session
from .actions.login import login
from .actions.navigate import go_home, go_profile
from .actions.screenshot import take_screenshot
from .logger import setup_logging

logger = setup_logging()
app = typer.Typer(add_completion=False, help="Instagram Web Flow Automation (Educational)")

@app.command("login-check")
def login_check(screenshot: bool = typer.Option(False, "--screenshot", help="Take screenshot after login")):
    """Opens Instagram, logs in, optionally takes a screenshot, then exits."""
    settings = get_settings()
    session = start_session(settings)
    try:
        login(session.page, settings.username, settings.password)
        if screenshot:
            take_screenshot(session.page, "login_check")
    finally:
        stop_session(session)

@app.command("home")
def home(screenshot: bool = typer.Option(False, "--screenshot", help="Take screenshot on home")):
    """Logs in, opens home, optionally takes a screenshot."""
    settings = get_settings()
    session = start_session(settings)
    try:
        login(session.page, settings.username, settings.password)
        go_home(session.page)
        if screenshot:
            take_screenshot(session.page, "home")
    finally:
        stop_session(session)

@app.command("profile")
def profile(screenshot: bool = typer.Option(False, "--screenshot", help="Take screenshot on profile")):
    """Logs in, opens your profile, optionally takes a screenshot."""
    settings = get_settings()
    session = start_session(settings)
    try:
        login(session.page, settings.username, settings.password)
        go_profile(session.page, settings.username, settings.profile_url)
        if screenshot:
            take_screenshot(session.page, "profile")
    finally:
        stop_session(session)

if __name__ == "__main__":
    app()
