from __future__ import annotations

from pathlib import Path
from datetime import datetime
from playwright.sync_api import Page
from ..logger import setup_logging

logger = setup_logging()

def take_screenshot(page: Page, name_prefix: str) -> str:
    out_dir = Path("artifacts") / "screenshots"
    out_dir.mkdir(parents=True, exist_ok=True)

    ts = datetime.now().strftime("%Y%m%d_%H%M%S")
    safe_prefix = "".join(ch if ch.isalnum() or ch in "-_" else "_" for ch in name_prefix)
    path = out_dir / f"{safe_prefix}_{ts}.png"

    page.screenshot(path=str(path), full_page=True)
    logger.info("Saved screenshot: %s", path.as_posix())
    return path.as_posix()
