from __future__ import annotations

from playwright.sync_api import Page
from ..logger import setup_logging

logger = setup_logging()

def go_home(page: Page) -> None:
    logger.info("Navigating to home...")
    page.goto("https://www.instagram.com/", wait_until="domcontentloaded")
    page.wait_for_timeout(1500)

def go_profile(page: Page, username: str, explicit_profile_url: str | None = None) -> None:
    url = explicit_profile_url or f"https://www.instagram.com/{username}/"
    logger.info("Opening profile: %s", url)
    page.goto(url, wait_until="domcontentloaded")
    page.wait_for_timeout(1500)
