# Instagram Web Flow Automation (Educational) — Python + Playwright

This project is a **safe, educational** Instagram web automation demo.
It is designed for learning browser automation patterns (login flow, navigation, screenshots, robust waits),
**NOT** for mass actions (auto-like/follow/comment/scrape).

## What it does
- Logs in to Instagram using your credentials (from `.env`)
- Optionally opens your profile page
- Takes screenshots for demo/proof
- Writes clean logs

## What it intentionally does NOT do
- No mass following/liking/commenting
- No scraping of user data
- No bypassing security / CAPTCHAs

> Note: Instagram may show additional verification challenges. In such cases, complete verification manually
in the browser window and rerun the command.

---

## 1) Requirements
- Python 3.10+
- Google Chrome / Chromium
- Playwright

## 2) Setup
```bash
python -m venv .venv
# windows:
.venv\Scripts\activate
# mac/linux:
source .venv/bin/activate

pip install -r requirements.txt
python -m playwright install chromium
```

## 3) Configure credentials
Copy `.env.example` to `.env` and set your values:
- `IG_USERNAME`
- `IG_PASSWORD`

## 4) Run
### A) Login check (opens browser, logs in, exits)
```bash
python -m instagram_bot.cli login-check
```

### B) Open your profile and take a screenshot
```bash
python -m instagram_bot.cli profile --screenshot
```

### C) Take only homepage screenshot (after login)
```bash
python -m instagram_bot.cli home --screenshot
```

## 5) Output
- Logs: `logs/app.log`
- Screenshots: `artifacts/screenshots/`

---

## Troubleshooting
- If you see a verification prompt, complete it manually, then rerun.
- If login fails, confirm username/password and try headful mode (default).
- If pages load slowly, increase `IG_TIMEOUT_MS` in `.env` (default 60000).
