from __future__ import annotations
from typing import Dict, Any, List, Optional, Tuple

class ValidationError(Exception):
    pass

def validate_required_columns(columns: List[str], required: Optional[List[str]] = None) -> None:
    if not required:
        return
    missing = [c for c in required if c not in columns]
    if missing:
        raise ValidationError(f"Missing required column(s): {', '.join(missing)}")

def validate_rows(rows: List[Dict[str, Any]], required: Optional[List[str]] = None) -> Tuple[int, List[str]]:
    """
    Basic per-row checks: required fields cannot be None.
    Returns: (invalid_count, sample_errors)
    """
    if not required:
        return 0, []
    invalid = 0
    errors = []
    for i, r in enumerate(rows, start=1):
        miss = [k for k in required if r.get(k) is None or r.get(k) == ""]
        if miss:
            invalid += 1
            if len(errors) < 5:
                errors.append(f"Row {i}: missing required value(s) {miss}")
    return invalid, errors
