# CSV to JSON Converter Pro (Python)

A ready-to-run project that converts CSV files into clean JSON with:
- Upload + preview (Streamlit UI)
- Field mapping (rename/drop) via UI or mapping.json
- Type inference (int/float/bool/date/null)
- Validation (required columns, basic type checks)
- Output formats: JSON Array, NDJSON, Grouped/Nested JSON
- Download output
- CLI tool for batch conversion

## 1) Setup

### Option A: Run UI (recommended)
```bash
python -m venv .venv
# Windows: .venv\Scripts\activate
# Linux/Mac: source .venv/bin/activate
pip install -r requirements.txt
streamlit run app/streamlit_app.py
```

### Option B: Run CLI
```bash
python cli.py --input data/sample_orders.csv --out output/result.json --format json_array
python cli.py --input data/sample_orders.csv --out output/result.ndjson --format ndjson
python cli.py --input data/sample_orders.csv --out output/grouped.json --format grouped --group-by OrderID
```

## 2) Mapping rules (optional)

You can pass a JSON mapping config:
- `rename`: {"OldName": "new_name"}
- `drop`: ["col_to_remove"]
- `defaults`: {"missing_col": "default_value"}
- `required`: ["col1", "col2"]
- `types`: {"Age":"int","Price":"float","IsActive":"bool","Date":"date","Name":"str"}

Example: `config/mapping.example.json` (create your own file similarly).

CLI example:
```bash
python cli.py --input data/sample_orders.csv --out output/result.json --format json_array --config config/mapping.example.json
```

## 3) Notes
- The project uses Pandas for convenience. For huge files, NDJSON mode can stream line-by-line.
- Grouped mode creates nested JSON using a group key (e.g., OrderID).

## 4) Folder Structure
- `app/streamlit_app.py` → UI
- `app/core/converter.py` → conversion engine
- `app/core/validator.py` → validation
- `app/utils/type_infer.py` → type detection
- `cli.py` → command line tool
- `data/` → sample CSV
- `output/` → generated outputs
