package com.loanlens.repository;

import com.loanlens.entity.LoanApplication;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface LoanApplicationRepository extends JpaRepository<LoanApplication, Long> {
    
    List<LoanApplication> findByUserIdOrderByCreatedAtDesc(Long userId);
    
    @Query("SELECT COUNT(la) FROM LoanApplication la")
    Long countTotalApplications();
    
    @Query("SELECT AVG(la.eligibilityScore) FROM LoanApplication la WHERE la.eligibilityScore IS NOT NULL")
    Double getAverageEligibilityScore();
    
    @Query("SELECT la.riskLevel, COUNT(la) FROM LoanApplication la WHERE la.riskLevel IS NOT NULL GROUP BY la.riskLevel")
    List<Object[]> getRiskLevelDistribution();
}
