package com.loanlens.dto;

import com.loanlens.entity.LoanApplication;
import jakarta.validation.constraints.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class EligibilityRequestDto {
    
    @NotNull(message = "Requested amount is required")
    @DecimalMin(value = "50000.00", message = "Minimum loan amount is ₹50,000")
    @DecimalMax(value = "20000000.00", message = "Maximum loan amount is ₹2,00,00,000")
    private BigDecimal requestedAmount;
    
    @NotNull(message = "Course type is required")
    private LoanApplication.CourseType courseType;
    
    @NotNull(message = "College tier is required")
    private LoanApplication.CollegeTier collegeTier;
    
    @NotNull(message = "Co-applicant income is required")
    @DecimalMin(value = "0.00", message = "Income cannot be negative")
    private BigDecimal coApplicantIncome;
    
    @NotNull(message = "Credit score is required")
    @Min(value = 300, message = "Credit score must be at least 300")
    @Max(value = 900, message = "Credit score cannot exceed 900")
    private Integer creditScore;
    
    @NotNull(message = "Existing liabilities amount is required")
    @DecimalMin(value = "0.00", message = "Liabilities cannot be negative")
    private BigDecimal existingLiabilities;
}
