package com.loanlens.controller;

import com.loanlens.dto.EligibilityRequestDto;
import com.loanlens.dto.EligibilityResponseDto;
import com.loanlens.service.EligibilityService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/eligibility")
public class EligibilityController {
    
    @Autowired
    private EligibilityService eligibilityService;
    
    @PostMapping("/check")
    public ResponseEntity<EligibilityResponseDto> checkEligibility(
            @Valid @RequestBody EligibilityRequestDto request) {
        EligibilityResponseDto response = eligibilityService.checkEligibility(request);
        return ResponseEntity.ok(response);
    }
}
