# 🎓 LoanLens – Student Loan Eligibility & EMI Planner System

## 📋 Project Overview

LoanLens is a comprehensive web application that helps students and parents make informed decisions about education loans by providing eligibility assessment, EMI calculations, and risk analysis.

## 🎯 Real-World Use Cases

### Scenario 1: Student Loan Application
A student wants ₹8 lakh education loan. They input:
- Course type (Engineering, Medical, MBA, etc.)
- College tier (Tier 1, 2, or 3)
- Co-applicant income
- Credit score
- Existing liabilities

**System Response:**
- Calculates eligibility score
- Shows maximum eligible loan amount
- Displays EMI options (5, 7, 10 years)
- Suggests safer tenure based on risk analysis

### Scenario 2: Affordability Check
Parent wants to know: "Can I afford this EMI?"

**System Response:**
- Calculates Debt-to-Income (DTI) ratio
- Shows risk indicator (Low / Medium / High)
- Provides recommendations

## ✨ Features

### 🟢 Core Features (MVP)

1. **Loan Eligibility Checker**
   - Income validation
   - Credit score logic
   - Debt-to-Income ratio calculation
   - Course risk category assessment
   - College tier impact factor

2. **EMI Calculator**
   - Dynamic tenure selection
   - Compound interest formula
   - Amortization schedule preview
   - Visual EMI breakdown

3. **Loan Comparison Module**
   - Compare multiple loan options
   - Interest rates comparison
   - EMI comparison
   - Total repayment analysis

4. **Risk Indicator System**
   - 🟢 Green (Safe - DTI < 30%)
   - 🟡 Yellow (Moderate - DTI 30-40%)
   - 🔴 Red (High Risk - DTI > 40%)

5. **Admin Panel**
   - Manage interest rates
   - Configure loan rules
   - View user simulations
   - Analytics dashboard

## 🛠️ Tech Stack

### Backend
- **Spring Boot 3.x** - Core framework
- **Spring Security** - JWT Authentication
- **Spring Data JPA** - Database operations
- **MySQL** - Database
- **Lombok** - Reduce boilerplate
- **ModelMapper** - DTO mapping
- **Validation** - Input validation

### Frontend
- **React 18** - UI library
- **React Router** - Navigation
- **Axios** - HTTP client
- **Tailwind CSS** - Styling
- **Chart.js / Recharts** - Data visualization
- **React Hook Form** - Form management
- **Zustand/Context API** - State management

### Development Tools
- **Maven** - Build tool
- **npm/yarn** - Package manager
- **Git** - Version control

## 📁 Project Structure

```
loanlens-project/
├── backend/                    # Spring Boot Application
│   ├── src/
│   │   ├── main/
│   │   │   ├── java/com/loanlens/
│   │   │   │   ├── config/        # Security, CORS configs
│   │   │   │   ├── controller/    # REST Controllers
│   │   │   │   ├── dto/           # Data Transfer Objects
│   │   │   │   ├── entity/        # JPA Entities
│   │   │   │   ├── repository/    # Database repositories
│   │   │   │   ├── service/       # Business logic
│   │   │   │   ├── security/      # JWT, Auth
│   │   │   │   ├── exception/     # Custom exceptions
│   │   │   │   └── util/          # Utility classes
│   │   │   └── resources/
│   │   │       ├── application.properties
│   │   │       └── data.sql       # Initial data
│   │   └── test/
│   └── pom.xml
│
├── frontend/                   # React Application
│   ├── public/
│   ├── src/
│   │   ├── components/         # Reusable components
│   │   ├── pages/              # Page components
│   │   ├── services/           # API services
│   │   ├── utils/              # Utility functions
│   │   ├── context/            # Context providers
│   │   ├── hooks/              # Custom hooks
│   │   ├── App.js
│   │   └── index.js
│   └── package.json
│
└── documentation/              # Additional docs
    ├── API_DOCUMENTATION.md
    ├── DATABASE_SCHEMA.md
    └── DEPLOYMENT_GUIDE.md
```

## 🚀 Getting Started

### Prerequisites
- Java 17 or higher
- Node.js 16+ and npm
- MySQL 8.0+
- Maven 3.6+

### Backend Setup

1. Navigate to backend directory:
```bash
cd backend
```

2. Configure MySQL in `application.properties`:
```properties
spring.datasource.url=jdbc:mysql://localhost:3306/loanlens_db
spring.datasource.username=your_username
spring.datasource.password=your_password
```

3. Build and run:
```bash
mvn clean install
mvn spring-boot:run
```

Backend will run on `http://localhost:8080`

### Frontend Setup

1. Navigate to frontend directory:
```bash
cd frontend
```

2. Install dependencies:
```bash
npm install
```

3. Configure API endpoint in `.env`:
```
REACT_APP_API_BASE_URL=http://localhost:8080/api
```

4. Start development server:
```bash
npm start
```

Frontend will run on `http://localhost:3000`

## 📊 Database Schema

### Key Tables
- **users** - User accounts
- **loan_applications** - Loan application records
- **eligibility_calculations** - Eligibility results
- **emi_schedules** - EMI calculation history
- **interest_rates** - Current interest rates
- **loan_rules** - Eligibility rules configuration

## 🔐 Authentication

The system uses JWT-based authentication:
- Register/Login endpoints
- Token-based API access
- Role-based access control (USER, ADMIN)

## 📈 API Endpoints

### Public Endpoints
- `POST /api/auth/register` - User registration
- `POST /api/auth/login` - User login

### Protected Endpoints
- `POST /api/eligibility/check` - Check loan eligibility
- `POST /api/emi/calculate` - Calculate EMI
- `GET /api/loans/compare` - Compare loans
- `GET /api/user/applications` - Get user applications

### Admin Endpoints
- `GET /api/admin/analytics` - Dashboard analytics
- `PUT /api/admin/interest-rates` - Update rates
- `PUT /api/admin/loan-rules` - Update rules

## 🧪 Testing

### Backend Tests
```bash
cd backend
mvn test
```

### Frontend Tests
```bash
cd frontend
npm test
```

## 📦 Deployment

### Backend Deployment
1. Build JAR file:
```bash
mvn clean package
```

2. Run JAR:
```bash
java -jar target/loanlens-0.0.1-SNAPSHOT.jar
```

### Frontend Deployment
1. Build production bundle:
```bash
npm run build
```

2. Deploy `build/` folder to hosting service

## 🤝 Contributing

1. Fork the repository
2. Create feature branch
3. Commit changes
4. Push to branch
5. Open pull request

## 📄 License

MIT License

## 👥 Authors

- Your Name - Initial work

## 🙏 Acknowledgments

- Spring Boot documentation
- React documentation
- EMI calculation formulas from financial standards
