package com.loanlens.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.UpdateTimestamp;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "loan_rules")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LoanRule {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(nullable = false, unique = true, length = 100)
    private String ruleName;
    
    @Column(nullable = false, length = 50)
    private String ruleType; // CREDIT_SCORE, DTI_RATIO, MAX_LOAN, etc.
    
    @Column(precision = 12, scale = 2)
    private BigDecimal minValue;
    
    @Column(precision = 12, scale = 2)
    private BigDecimal maxValue;
    
    @Column(precision = 5, scale = 2)
    private BigDecimal threshold;
    
    @Column(columnDefinition = "TEXT")
    private String description;
    
    @Column(nullable = false)
    private Boolean active = true;
    
    @UpdateTimestamp
    private LocalDateTime updatedAt;
}
