package com.loanlens.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.UpdateTimestamp;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "interest_rates")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InterestRate {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(nullable = false, unique = true, length = 100)
    private String bankName;
    
    @Column(nullable = false, precision = 5, scale = 2)
    private BigDecimal baseRate;
    
    @Column(precision = 5, scale = 2)
    private BigDecimal minRate;
    
    @Column(precision = 5, scale = 2)
    private BigDecimal maxRate;
    
    @Column(precision = 5, scale = 2)
    private BigDecimal processingFeePercentage;
    
    @Column(nullable = false)
    private Boolean active = true;
    
    @UpdateTimestamp
    private LocalDateTime updatedAt;
    
    @Column(columnDefinition = "TEXT")
    private String specialOffer;
}
