package com.loanlens.dto;

import com.loanlens.entity.LoanApplication;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class EligibilityResponseDto {
    
    private Long applicationId;
    private Boolean eligible;
    private BigDecimal requestedAmount;
    private BigDecimal eligibleAmount;
    private BigDecimal eligibilityScore;
    private BigDecimal debtToIncomeRatio;
    private LoanApplication.RiskLevel riskLevel;
    private String riskMessage;
    private String recommendation;
    private List<EmiOptionDto> emiOptions;
    private String suggestedTenure;
}
