package com.loanlens.controller;

import com.loanlens.entity.LoanApplication;
import com.loanlens.entity.User;
import com.loanlens.repository.LoanApplicationRepository;
import com.loanlens.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/loans")
public class LoanController {
    
    @Autowired
    private LoanApplicationRepository loanApplicationRepository;
    
    @Autowired
    private UserRepository userRepository;
    
    @GetMapping("/my-applications")
    public ResponseEntity<List<LoanApplication>> getMyApplications() {
        String email = SecurityContextHolder.getContext().getAuthentication().getName();
        User user = userRepository.findByEmail(email)
                .orElseThrow(() -> new RuntimeException("User not found"));
        
        List<LoanApplication> applications = loanApplicationRepository
                .findByUserIdOrderByCreatedAtDesc(user.getId());
        return ResponseEntity.ok(applications);
    }
    
    @GetMapping("/application/{id}")
    public ResponseEntity<LoanApplication> getApplicationById(@PathVariable Long id) {
        LoanApplication application = loanApplicationRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("Application not found"));
        
        // Verify ownership
        String email = SecurityContextHolder.getContext().getAuthentication().getName();
        if (!application.getUser().getEmail().equals(email)) {
            return ResponseEntity.status(403).build();
        }
        
        return ResponseEntity.ok(application);
    }
}
