# Manual Test Cases for UPI Fraud Detection System

## Prerequisites
Make sure your API server is running. Check these URLs first:
- http://localhost:8000/docs
- http://localhost:8001/docs  
- http://localhost:8002/docs

## Test Case 1: Health Check
**Method:** GET  
**URL:** `http://localhost:8000/health` (or whatever port your server is running on)  
**Expected Response:**
```json
{
  "status": "healthy",
  "timestamp": "2026-02-02T14:15:00.000Z",
  "version": "1.0.0"
}
```

## Test Case 2: Legitimate Transaction
**Method:** POST  
**URL:** `http://localhost:8000/predict`  
**Headers:** `Content-Type: application/json`  
**Body:**
```json
{
  "transaction_id": "TXN123456789",
  "upi_id": "user@paytm",
  "amount": 500.00,
  "merchant": "Grocery Store",
  "timestamp": "2026-02-02T10:30:00",
  "location": "Mumbai",
  "device_id": "DEV001"
}
```
**Expected Response:** `is_fraud: false` with low risk score

## Test Case 3: High Amount Suspicious Transaction
**Method:** POST  
**URL:** `http://localhost:8000/predict`  
**Body:**
```json
{
  "transaction_id": "TXN987654321",
  "upi_id": "suspicious@phonepe",
  "amount": 50000.00,
  "merchant": "Unknown Merchant",
  "timestamp": "2026-02-02T02:30:00",
  "location": "Unknown",
  "device_id": "DEV999"
}
```
**Expected Response:** `is_fraud: true` with high risk score

## Test Case 4: Night Time Transaction
**Method:** POST  
**URL:** `http://localhost:8000/predict`  
**Body:**
```json
{
  "transaction_id": "TXN_NIGHT_001",
  "upi_id": "nightuser@gpay",
  "amount": 15000.00,
  "merchant": "ATM Withdrawal",
  "timestamp": "2026-02-02T02:30:00",
  "location": "Remote Area",
  "device_id": "DEV_NIGHT"
}
```
**Expected Response:** Likely flagged as suspicious due to odd timing

## Test Case 5: Small Legitimate Transaction
**Method:** POST  
**URL:** `http://localhost:8000/predict`  
**Body:**
```json
{
  "transaction_id": "TXN_SMALL_001",
  "upi_id": "regular@paytm",
  "amount": 50.00,
  "merchant": "Coffee Shop",
  "timestamp": "2026-02-02T12:00:00",
  "location": "Delhi",
  "device_id": "DEV_REGULAR"
}
```
**Expected Response:** `is_fraud: false` with very low risk score

## Testing with curl Commands

### Health Check
```bash
curl -X GET http://localhost:8000/health
```

### Fraud Detection Test
```bash
curl -X POST http://localhost:8000/predict \
  -H "Content-Type: application/json" \
  -d '{
    "transaction_id": "TEST_001",
    "upi_id": "test@paytm",
    "amount": 1000.00,
    "merchant": "Test Store",
    "timestamp": "2026-02-02T12:00:00",
    "location": "Mumbai",
    "device_id": "TEST_DEVICE"
  }'
```

### Model Status
```bash
curl -X GET http://localhost:8000/model/status
```

### Metrics
```bash
curl -X GET http://localhost:8000/metrics
```

## Testing with Postman or Browser

1. **Open API Documentation:**
   - Go to http://localhost:8000/docs (replace 8000 with your actual port)
   - This gives you interactive API testing

2. **Test Health Endpoint:**
   - Click on GET /health
   - Click "Try it out"
   - Click "Execute"

3. **Test Fraud Detection:**
   - Click on POST /predict
   - Click "Try it out"
   - Enter sample transaction data
   - Click "Execute"

## Expected Fraud Detection Results

| Transaction Type | Amount | Time | Expected Result |
|------------------|--------|------|----------------|
| Regular Purchase | $50-500 | 9AM-9PM | Safe (is_fraud: false) |
| High Amount | $10,000+ | Any | Suspicious (is_fraud: true) |
| Night Transaction | Any | 12AM-5AM | Suspicious (is_fraud: true) |
| Multiple Rapid | Any | Quick succession | Suspicious (is_fraud: true) |

## Frontend Testing

1. **Open Dashboard:** http://localhost:3000
2. **Test Features:**
   - View real-time transaction feed
   - Check fraud statistics
   - Test interactive charts
   - Verify responsive design

## Troubleshooting

- **Port Issues:** Try ports 8000, 8001, 8002, or 8003
- **CORS Errors:** Make sure both frontend and backend are running
- **Missing Data:** Some test cases might return minimal data if models aren't fully trained