import React from 'react';
import { useNavigate } from 'react-router-dom';
import {
    Grid, Paper,
    Box, Container
} from '@mui/material';
import { AccountCircle, School } from '@mui/icons-material';
import styled from 'styled-components';

const ChooseUser = () => {
    const navigate = useNavigate()

    const navigateHandler = (user) => {
        if (user === "Admin") {
            navigate('/Adminlogin');
        }
        else if (user === "Client") {
            navigate('/Clientlogin');
        }
    }

    return (
        <StyledContainer>
            <Container>
                <Grid container spacing={2} justifyContent="center">
                    <Grid item xs={12} sm={6} md={4}>
                        <div onClick={() => navigateHandler("Admin")}>
                            <StyledPaper elevation={3}>
                                <Box mb={2}>
                                    <AccountCircle fontSize="large" />
                                </Box>
                                <StyledTypography>
                                    Admin
                                </StyledTypography>
                                Login as an administrator to manage the system.
                            </StyledPaper>
                        </div>
                    </Grid>
                    <Grid item xs={12} sm={6} md={4}>
                        <StyledPaper elevation={3}>
                            <div onClick={() => navigateHandler("Client")}>
                                <Box mb={2}>
                                    <School fontSize="large" />
                                </Box>
                                <StyledTypography>
                                    Client
                                </StyledTypography>
                                Login as a user to add tasks and perform CRUD operations.
                            </div>
                        </StyledPaper>
                    </Grid>
                </Grid>
            </Container>
        </StyledContainer>
    );
};

export default ChooseUser;

const StyledContainer = styled.div`
  background: linear-gradient(to bottom, #411d70, #19118b);
  height: 120vh;
  display: flex;
  justify-content: center;
  padding: 2rem;
`;

const StyledPaper = styled(Paper)`
  padding: 20px;
  text-align: center;
  background-color: #1f1f38;
  color:rgba(255, 255, 255, 0.6);
  cursor:pointer;

  &:hover {
    background-color: #2c2c6c;
    color:white;
  }
`;

const StyledTypography = styled.h2`
  margin-bottom: 10px;
`;