const jwt = require("jsonwebtoken");

const createNewToken = (payload) => {
    // Support both JWT_SECRET (used in .env) and SECRET_KEY (older name)
    const secret = process.env.JWT_SECRET || process.env.SECRET_KEY;
    if (!secret) {
        throw new Error('JWT secret not set. Please set JWT_SECRET or SECRET_KEY in environment variables.');
    }
    return jwt.sign({ userId: payload }, secret, { expiresIn: '1d' });
}

module.exports = { createNewToken }