<?php 
session_start();
require 'PHPMailer/PHPMailerAutoload.php'; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Signatory Signup</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="css/general.css" rel="stylesheet">
    <link href="css/custom.css" rel="stylesheet">
    <link href="css/owl.carousel.css" rel="stylesheet">
    <link href="css/owl.theme.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link rel="stylesheet" href="css/magnific-popup.css">

    <script src="js/modernizr-2.8.3.min.js"></script>  
</head>

<body id="home">

<?php
$email = '';
$flag = 1;
try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (!empty($_POST["email"]) && !empty($_POST["password"])) {
            $email = trim($_POST['email']);
            $pass = $_POST['password'];
            $cpass = $_POST['confirm_password'];

            if ($pass !== $cpass) {
                $flag = -1;
            } else {
                $conn = new mysqli("localhost", "root", "", "sms");

                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }

                $sql = "SELECT upMail FROM student UNION SELECT upMail FROM signatory";
                $result = $conn->query($sql);

                if ($result && $result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        if($row["upMail"] == $email){
                            $flag = 0;
                            break;
                        }
                    }
                }

                if($flag == 0){
                    $_SESSION['errMsg'] = "User Already Exists!";
                } else if($flag == -1){
                    $_SESSION['errMsg'] = "Password and Confirm Password do not match.";
                } else {
                    $phash = password_hash($pass, PASSWORD_DEFAULT);

                    $insert = "INSERT INTO signatory(upMail, password) VALUES (?, ?)";
                    $stmt = $conn->prepare($insert);
                    $stmt->bind_param("ss", $email, $phash);

                    if ($stmt->execute()) {
                        $sixdigitnum = rand(100001, 999999);

                        $verify = "INSERT INTO verify_signup(upMail, num) VALUES (?, ?)";
                        $vstmt = $conn->prepare($verify);
                        $vstmt->bind_param("si", $email, $sixdigitnum);
                        $vstmt->execute();

                        // Send Verification Email
                        $emailfrom = "bindrani.rb7@gmail.com";
                        $passfrom = "8128962439rb";
                        $mail = new PHPMailer;

                        $mail->isSMTP();
                        $mail->Host = 'smtp.gmail.com';
                        $mail->SMTPAuth = true;
                        $mail->Username = $emailfrom;
                        $mail->Password = $passfrom;
                        $mail->SMTPSecure = 'tls';
                        $mail->Port = 587;

                        $mail->setFrom($emailfrom, 'SMS');
                        $mail->addAddress($email);
                        $mail->isHTML(true);

                        $bodyContent = "
                        <h1>Thanks for signing up!</h1>
                        <p>Your account has been created. Please use the following verification code:</p>
                        <h2>$sixdigitnum</h2>
                        <p>Thank you for using our website!</p>";

                        $mail->Subject = 'Signup | Verification';
                        $mail->Body    = $bodyContent;

                        if(!$mail->send()) {
                            echo 'Mailer Error: ' . $mail->ErrorInfo;
                        } else {
                            $_SESSION['email'] = $email;
                            echo "<script>
                                alert('Your Account has been created. Please check your Email for verification!');
                                window.location.href='backend/verify_signupcode.php';
                            </script>";
                        }
                    } else {
                        echo "Error: " . $stmt->error;
                    }
                    $stmt->close();
                }
                $conn->close();
            }
        }
    }
} catch(Exception $e) {
    echo $e->getMessage();
}
?>

<div class="intro-header">
    <div class="col-xs-12 text-center">
        <h1 class="h1_home wow fadeIn" data-wow-delay="0.4s">SMS</h1>
        <h3 class="h3_home wow fadeIn" data-wow-delay="0.6s">Scholarship Management System || UPDATEGADH</h3>
        <h3 class="h3_home wow fadeIn" data-wow-delay="0.6s">Signatory Signup</h3>
        <h3 class="h3_home wow fadeIn" data-wow-delay="0.6s">Create Your Account</h3>

        <div class="login">
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="POST">
                <input type="email" name="email" value="<?php echo $email; ?>" placeholder="Enter Email Address" class="h3_home wow fadeIn" data-wow-delay="0.8s" required autofocus>
                <input type="password" name="password" id="password" placeholder="Enter Password" class="h3_home wow fadeIn" data-wow-delay="1.0s" required>
                <input type="password" name="confirm_password" id="confirm_password" placeholder="Confirm Password" class="h3_home wow fadeIn" data-wow-delay="1.2s" required>
                <input type="submit" class="btn btn-lg mybutton_standard wow swing wow fadeIn network-name text-center" data-wow-delay="1.2s" value="Signup">

                <h5 class="h3_home wow fadeIn" data-wow-delay="1.4s">Already have an Account? 
                    <a style="color:white" href="index.php"><u>Click Here</u></a>
                </h5>

                <h5 class="h3_home wow fadeIn" data-wow-delay="1.6s">Signup as a 
                    <a style="color:white" href="signup_student.php"><u>Student</u></a>
                </h5>
            </form>

            <?php
            if(!empty($_SESSION['errMsg'])){ ?>
                <div class="wow fadeIn" data-wow-delay="1.8s">
                    <div class="alert alert-danger wow swing text-center" data-wow-delay="2.2s" style="margin-top:20px;">
                        <center><strong>Invalid! </strong><?php echo $_SESSION['errMsg']; ?></center>
                    </div>
                </div>
            <?php unset($_SESSION['errMsg']); } ?>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script src="js/jquery-1.10.2.js"></script>
<script src="js/bootstrap.js"></script>
<script src="js/owl.carousel.js"></script>
<script src="js/script.js"></script>
<script src="js/stickUp.min.js"></script>
<script type="text/javascript">
    jQuery(function($) {
        $(document).ready(function() {
            $('.navbar-default').stickUp();
        });
    });
</script>
<script src="js/jquery.corner.js"></script>
<script src="js/wow.min.js"></script>
<script>
    new WOW().init();
</script>
<script src="js/classie.js"></script>
<script src="js/uiMorphingButton_inflow.js"></script>
<script src="js/jquery.magnific-popup.js"></script>

</body>
</html>
