"""rms URL Configuration

The `urlpatterns` list routes URLs to views. For more information, see:
    https://docs.djangoproject.com/en/3.0/topics/http/urls/
"""

from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.contrib.auth import views as auth_views
from registers import views  # your main app views

# -------------------- MAIN URLS -------------------- #
urlpatterns = [
    path('admin/', admin.site.urls),

    # Homepage and dashboard
    path('', views.first_page, name="home"),
    path('dashboard/', views.dashboard, name="dashboard"),

    # User, Customer, Product, and Order apps
    path('user/', include(('registers.urls', 'register_app'), namespace='register_app')),
    path('customers/', include(('customers.urls', 'customer_app'), namespace='customer_app')),
    path('products/', include(('products.urls', 'product_app'), namespace='product_app')),
    path('orders/', include(('orders.urls', 'order_app'), namespace='order_app')),

    # -------------------- LOGOUT -------------------- #
    # Using Django's built-in LogoutView for safety
    path(
        'user/logout/',
        auth_views.LogoutView.as_view(next_page='/user/login/'),
        name='logout'
    ),

    # -------------------- PASSWORD RESET -------------------- #
    path(
        'reset_password/',
        auth_views.PasswordResetView.as_view(
            template_name='passwordreset/password_reset_email.html'
        ),
        name="password_reset"
    ),
    path(
        'reset_password_sent/',
        auth_views.PasswordResetDoneView.as_view(
            template_name='passwordreset/password_reset_sent.html'
        ),
        name="password_reset_done"
    ),
    path(
        'reset/<uidb64>/<token>/',
        auth_views.PasswordResetConfirmView.as_view(
            template_name='passwordreset/password_reset_form.html'
        ),
        name="password_reset_confirm"
    ),
    path(
        'reset_password_complete/',
        auth_views.PasswordResetCompleteView.as_view(
            template_name='passwordreset/password_reset_complete.html'
        ),
        name="password_reset_complete"
    ),
]

# -------------------- MEDIA FILE SERVING -------------------- #
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
