import os
from pathlib import Path
import django_on_heroku  # for Heroku deployment
import dj_database_url
from decouple import config, Csv

# -------------------- BASE CONFIG -------------------- #
BASE_DIR = Path(__file__).resolve().parent.parent

SECRET_KEY = config("SECRET_KEY", default="your-secret-key")

DEBUG = True  # ⚠️ Set to False in production

ALLOWED_HOSTS = ['127.0.0.1', 'localhost', 'djangosupermarket.herokuapp.com']


# -------------------- INSTALLED APPS -------------------- #
INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    # Third-party apps
    'import_export',
    'widget_tweaks',
    'crispy_forms',
    'crispy_bootstrap5',  
    'django_filters',
    'bootstrap_modal_forms',
    'storages',
    'django.contrib.humanize',

    # Local apps
    'customers',
    'products',
    'orders',
    'registers',
]

# Crispy Forms Settings
CRISPY_ALLOWED_TEMPLATE_PACKS = "bootstrap5"
CRISPY_TEMPLATE_PACK = "bootstrap5"


# -------------------- MIDDLEWARE -------------------- #
MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'rms.urls'

# -------------------- TEMPLATES -------------------- #
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR / 'templates'],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'rms.wsgi.application'


# -------------------- DATABASE CONFIG -------------------- #
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}

# For PostgreSQL on Heroku (uncomment when deploying)
# DATABASES = {
#     'default': dj_database_url.config(conn_max_age=600, ssl_require=True)
# }


# -------------------- PASSWORD VALIDATION -------------------- #
AUTH_PASSWORD_VALIDATORS = [
    {'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator'},
    {'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator'},
    {'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator'},
    {'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator'},
]


# -------------------- INTERNATIONALIZATION -------------------- #
LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'Asia/Kathmandu'
USE_I18N = True
USE_L10N = True
USE_TZ = True


# -------------------- STATIC & MEDIA FILES -------------------- #
STATIC_URL = '/static/'
STATIC_ROOT = BASE_DIR / 'staticfiles'
STATICFILES_DIRS = [BASE_DIR / "static"]

MEDIA_URL = '/media/'
MEDIA_ROOT = BASE_DIR / 'media'


# -------------------- MESSAGE TAGS -------------------- #
from django.contrib.messages import constants as messages
MESSAGE_TAGS = {
    messages.DEBUG: 'alert-info',
    messages.INFO: 'alert-info',
    messages.SUCCESS: 'alert-success',
    messages.WARNING: 'alert-warning',
    messages.ERROR: 'alert-danger',
}


# -------------------- EMAIL CONFIG (Gmail) -------------------- #
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'smtp.gmail.com'
EMAIL_PORT = 587
EMAIL_USE_TLS = True
EMAIL_HOST_USER = 'nirmalpandey27450112@gmail.com'
EMAIL_HOST_PASSWORD = 'ffutdfvwvodrjztp'  # Gmail App Password ⚠️ Use environment var in production


# -------------------- LOGIN / LOGOUT -------------------- #
LOGOUT_REDIRECT_URL = '/user/login'


# -------------------- AUTO FIELD CONFIG -------------------- #
DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


# -------------------- HEROKU SETTINGS -------------------- #
# Comment out if working locally only
django_on_heroku.settings(locals())
