"""rms package initialization.

Provide a lightweight shim to allow using PyMySQL as a drop-in
replacement for MySQLdb (mysqlclient). This lets projects avoid
installing the compiled mysqlclient wheel on Windows.

To use this shim, install PyMySQL in your virtualenv:

	pip install PyMySQL

If you prefer to use the binary mysqlclient package, uninstall PyMySQL
and install the appropriate mysqlclient wheel for your Python version.
"""

try:
	# Import here so it's a no-op unless PyMySQL is installed.
	import pymysql

	# Make PyMySQL act as MySQLdb for Django and libraries expecting
	# the MySQLdb module name.
	pymysql.install_as_MySQLdb()
except Exception:
	# If PyMySQL isn't installed, do nothing and allow normal mysqlclient
	# (MySQLdb) to be used instead. Import errors will surface later when
	# Django tries to connect to the DB if no driver is available.
	pass
