from django.urls import path
from registers import views
from django.contrib.auth import views as auth_views

app_name = 'register_app'

urlpatterns = [
    # Authentication URLs
    path('login/', views.loginPage, name="login"),
    path('register/', views.SignupView, name="register"),
    path('logout/', views.UserLogoutView.as_view(), name="logout"),
    path('profile/', views.UserProfile, name="user_view"),

    # Password reset (optional)
    path(
        'reset_password/',
        auth_views.PasswordResetView.as_view(
            template_name='passwordreset/password_reset_email.html'
        ),
        name="password_reset"
    ),
    path(
        'reset_password_sent/',
        auth_views.PasswordResetDoneView.as_view(
            template_name='passwordreset/password_reset_sent.html'
        ),
        name="password_reset_done"
    ),
    path(
        'reset/<uidb64>/<token>/',
        auth_views.PasswordResetConfirmView.as_view(
            template_name='passwordreset/password_reset_form.html'
        ),
        name="password_reset_confirm"
    ),
    path(
        'reset_password_complete/',
        auth_views.PasswordResetCompleteView.as_view(
            template_name='passwordreset/password_reset_complete.html'
        ),
        name="password_reset_complete"
    ),
]
