<?php
// Start the session
session_start();

// Include required configuration and connection files
include '../Config/connect.php'; // This should define $link

// Retrieve POST data
$Product = $_POST["Product"];
$Price = $_POST["Price"];

// Check if the product exists in the database
$query = "SELECT * FROM Price WHERE IDProduct = ?";
$stmt = mysqli_prepare($link, $query);

if ($stmt) {
    mysqli_stmt_bind_param($stmt, "i", $Product);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    // Determine whether to update or insert
    if ($row = mysqli_fetch_assoc($result)) {
        // Product exists, update the price
        $updateQuery = "UPDATE Price SET Price = ? WHERE IDProduct = ?";
        $updateStmt = mysqli_prepare($link, $updateQuery);

        if ($updateStmt) {
            mysqli_stmt_bind_param($updateStmt, "di", $Price, $Product);
            if (mysqli_stmt_execute($updateStmt)) {
                echo "<script>alert('The Price is successfully updated');</script>";
                echo "<script>location.href='../Settings.php';</script>";
            } else {
                echo "<script>alert('Error updating the price');</script>";
                echo "<script>location.href='../Settings.php';</script>";
            }
            mysqli_stmt_close($updateStmt);
        }
    } else {
        // Product does not exist, insert a new price
        $insertQuery = "INSERT INTO Price (IDProduct, Price) VALUES (?, ?)";
        $insertStmt = mysqli_prepare($link, $insertQuery);

        if ($insertStmt) {
            mysqli_stmt_bind_param($insertStmt, "id", $Product, $Price);
            if (mysqli_stmt_execute($insertStmt)) {
                echo "<script>alert('The Price is successfully added');</script>";
                echo "<script>location.href='../Settings.php';</script>";
            } else {
                echo "<script>alert('Error adding the price');</script>";
                echo "<script>location.href='../Settings.php';</script>";
            }
            mysqli_stmt_close($insertStmt);
        }
    }

    mysqli_stmt_close($stmt);
} else {
    die("Error preparing statement: " . mysqli_error($link));
}

// Close the connection
mysqli_close($link);
?>
